/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.registry;

import com.dfdyz.epicacg.world.item.FireFlySwordItem;
import com.dfdyz.epicacg.world.item.GenShinImpact.BowWeaponItem;
import com.dfdyz.epicacg.world.item.SimpleWeaponItem;
import com.dfdyz.epicacg.world.item.SpecialWeaponItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class Items {
    static final List<RegistryObject<Item>> REGISTRY_OBJECTS = new ArrayList<RegistryObject<Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"epicacg");
    public static final RegistryObject<Item> TrainingBow = Items.register("training_bow", () -> new BowWeaponItem(Items.weapon().m_41503_(600)));
    public static final RegistryObject<Item> BattleScythe = Items.register("battle_scythe", () -> new SimpleWeaponItem(Items.weapon(), (Tier)Tiers.DIAMOND, 8));
    public static final RegistryObject<Item> Elucidator = Items.register("elucidator", () -> new SpecialWeaponItem(Items.weapon(), EpicACGTier.SAO_Special, 15));
    public static final RegistryObject<Item> DarkRepulsor = Items.register("dark_repulsor", () -> new SimpleWeaponItem(Items.weapon(), EpicACGTier.SAO_Normal, 15));
    public static final RegistryObject<Item> LambentLight = Items.register("lambent_light", () -> new SimpleWeaponItem(Items.weapon(), EpicACGTier.SAO_Normal, 15));
    public static final RegistryObject<Item> SlimeSpear = Items.register("slime_spear", () -> new SimpleWeaponItem(Items.weapon(), EpicACGTier.SAO_Normal, 15));
    public static final RegistryObject<Item> FireFlySword = Items.register("firefly_sword", () -> new FireFlySwordItem(new Item.Properties().m_41487_(1), EpicACGTier.SAO_Normal, 15));
    public static final RegistryObject<Item> DragonShitCrystal = Items.register("dragon_shit_crystal", () -> new Item(new Item.Properties().m_41487_(16)));

    public static Item.Properties weapon() {
        return new Item.Properties().m_41487_(1);
    }

    public static RegistryObject<Item> register(String n, Supplier<Item> s) {
        RegistryObject i = ITEMS.register(n, s);
        REGISTRY_OBJECTS.add((RegistryObject<Item>)i);
        return i;
    }

    public static enum EpicACGTier implements Tier
    {
        SAO_Normal(4, 9999, 9.0f, 6.0f, 22, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_41959_})),
        SAO_IRON(2, 380, 6.0f, 2.5f, 17, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42416_})),
        SAO_Special(4, Integer.MAX_VALUE, 9.0f, 6.0f, 22, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_41959_}));

        private final int harvestLevel;
        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int enchantability;
        private final LazyLoadedValue<Ingredient> repairMaterial;

        private EpicACGTier(int harvestLevelIn, int maxUsesIn, float efficiencyIn, float attackDamageIn, int enchantabilityIn, Supplier repairMaterialIn) {
            this.harvestLevel = harvestLevelIn;
            this.maxUses = maxUsesIn;
            this.efficiency = efficiencyIn;
            this.attackDamage = attackDamageIn;
            this.enchantability = enchantabilityIn;
            this.repairMaterial = new LazyLoadedValue(repairMaterialIn);
        }

        public int m_6609_() {
            return this.maxUses;
        }

        public float m_6624_() {
            return this.efficiency;
        }

        public float m_6631_() {
            return this.attackDamage;
        }

        public int m_6604_() {
            return this.harvestLevel;
        }

        public int m_6601_() {
            return this.enchantability;
        }

        @NotNull
        public Ingredient m_6282_() {
            return (Ingredient)this.repairMaterial.m_13971_();
        }
    }
}

